/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.atmSW;

import ibm.nways.atmSW.StarViewWidget;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.NMPlatformDBClient;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.snmp.SnmpSessionFactory;
import ibm.nways.ras.RAS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class AtmView
extends Panel {
    private GenModel viewModel;
    private GenModel ifModel;
    private GenModel neighborModel;
    private BrowserApplet browser;
    private StarViewWidget starView;
    private static ResourceBundle resources = null;
    private NMPlatformDBClient db;
    private static String[][] oidToImage = new String[][]{{"1.3.6.1.4.1.2.6.33.1", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.33.2.1", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.33.2.2", "iub_IBMATMWG.gif"}, {"1.3.6.1.4.1.2.6.33.2.3", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.81", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.28", "iub_IBMMULTIBRIDGE.gif"}, {"1.3.6.1.4.1.2.6.28.9.1", "iub_IBMMULTIBRIDGE.gif"}, {"1.3.6.1.4.1.2.6.118.2", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.118.3", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.118.5", "iub_IBMMULTISWHUB.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.108", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.216", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.524", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.612", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.624", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.712", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.212", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.98.1.1.412", "iub_IBMEnetWGSW.gif"}, {"1.3.6.1.4.1.2.6.66.1.1.108", "iub_IBMTRWGSW.gif"}, {"1.3.6.1.4.1.2.6.66.1.1.216", "iub_IBMTRWGSW.gif"}, {"1.3.6.1.4.1.2.6.66.1.1.208", "iub_IBMTRWGSW.gif"}, {"1.3.6.1.4.1.2.6.66.1.1.408", "iub_IBMTRWGSW.gif"}, {"1.3.6.1.4.1.2.6.66.1.1.600", "iub_IBMTRWGSW.gif"}, {"1.3.6.1.4.1.2.6.66.1.1.800", "iub_IBMTRWGSW.gif"}, {"1.3.6.1.4.1.2.6.72", "iub_IBMMULTIROUTER.gif"}, {"1.3.6.1.4.1.2.6.131", "iub_IBMMULTIROUTER.gif"}};

    public AtmView(BrowserApplet browserApplet, GenModel genModel, GenModel genModel2) {
        String string = "AtmView";
        this.browser = browserApplet;
        this.viewModel = genModel;
        this.ifModel = genModel2;
        this.setLayout(new BorderLayout());
        this.starView = new StarViewWidget();
        if (resources == null) {
            resources = ResourceBundle.getBundle("ibm.nways.atmSW.Resources");
        }
        this.add("Center", (Component)this.starView);
        String string2 = "127.0.0.1";
        String string3 = this.browser.getCodeBase().getHost();
        try {
            if (string3 != null && !string3.equals("") && string3.startsWith("http://")) {
                string2 = string3;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1008, this, string, exception);
        }
        try {
            if (genModel != null) {
                GenModel genModel3;
                this.neighborModel = genModel3 = (GenModel)genModel.getComponent("NeighborTable");
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 1008, this, string, exception);
        }
        this.db = new NMPlatformDBClient();
        NMPlatformDBClient.init(string2);
        this.refresh();
    }

    public void displayMessage(String string) {
        this.browser.displayMsg(resources.getString(string));
    }

    public void refresh() {
        this.displayMessage("retrieve_information");
        if (this.viewModel != null) {
            try {
                Image image = this.browser.imageFrom((Object)this, "icon_atm.gif");
                Vector vector = this.viewModel.getRestOfInfo("Panel", "default", null, null);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    GraphicActionNavigate graphicActionNavigate;
                    Object object;
                    String string;
                    Object object2;
                    Object object3;
                    ModelInfo modelInfo;
                    ModelInfo modelInfo2 = (ModelInfo)enumeration.nextElement();
                    String string2 = modelInfo2.get("Index.NbrIndex").toString();
                    String string3 = modelInfo2.get("Panel.NbrIpAddress1").toString();
                    String string4 = modelInfo2.get("Panel.NbrIpAddress2").toString();
                    String string5 = string3;
                    if (string5.equals("0.0.0.0")) {
                        string5 = string4;
                    }
                    GraphicImage graphicImage = new GraphicImage(image, new Point(0, 0), 0);
                    Object[] objectArray = new Object[]{string2};
                    I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.atmSW.Resources", "ATMView_Interface", objectArray);
                    graphicImage.setFlyOver(new GraphicFlyOver(i18NMsgFormat.getTranslation()));
                    if (this.ifModel != null) {
                        modelInfo = new ModelInfo();
                        modelInfo.add("Index.InterfaceIndex", modelInfo2.get("Index.NbrIndex"));
                        object3 = this.ifModel.getStatusRefForRow(modelInfo);
                        object2 = new StatusProxy((RemoteStatus)object3);
                        graphicImage.setStatus((Status)object2);
                        string = "ibm.nways.atmSW.eui.AtmSWInterfacePanel";
                        object = new NavigationContext();
                        NavInitialRow.setInitialRow((NavigationContext)object, (ModelInfo)modelInfo);
                        graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.browser, new NavigationDestination(string, (RemoteModel)this.ifModel), (NavigationContext)object);
                        graphicImage.setAction((GraphicAction)graphicActionNavigate);
                    }
                    modelInfo = null;
                    if (!string5.equals("0.0.0.0")) {
                        object3 = modelInfo2.get("Panel.NbrOid").toString();
                        if (!((String)object3).startsWith("1.3.6")) {
                            object3 = this.getOidFromDB(string5);
                        }
                        object2 = AtmView.getImageFromOid((String)object3);
                        modelInfo = new GraphicImage(this.browser.imageFrom((Object)this, (String)object2), new Point(0, 0), 0);
                        if (this.neighborModel != null) {
                            string = "ibm.nways.atmSW.eui.NeighborTablePanel";
                            object = new ModelInfo();
                            ((ModelInfo)object).add("Index.NbrIndex", modelInfo2.get("Index.NbrIndex"));
                            graphicActionNavigate = new NavigationContext();
                            NavInitialRow.setInitialRow((NavigationContext)graphicActionNavigate, (ModelInfo)object);
                            GraphicActionNavigate graphicActionNavigate2 = new GraphicActionNavigate((GraphicHandler)this.browser, new NavigationDestination(string, (RemoteModel)this.neighborModel), (NavigationContext)graphicActionNavigate);
                            modelInfo.setAction((GraphicAction)graphicActionNavigate2);
                        }
                        modelInfo.setFlyOver(new GraphicFlyOver(string5));
                        modelInfo.addPopupMenuItem(this.getDeviceMenuItem(string5));
                    }
                    this.starView.addInterfaceAndDevice(graphicImage, string2, (GraphicImage)modelInfo, string5);
                }
                this.starView.setSize(this.starView.getOptimumSize());
                this.starView.calculatePositions();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.displayMessage("done");
    }

    private String getReadCommunity(NMPlatformDBClient nMPlatformDBClient, String string) {
        Hashtable hashtable = SnmpSessionFactory.getConfigInfo((String)string);
        Serializable serializable = (Serializable)hashtable.get("readComm");
        if (serializable != null) {
            return serializable.toString();
        }
        return NMPlatformDBClient.getCommunityName(string);
    }

    private String getWriteCommunity(NMPlatformDBClient nMPlatformDBClient, String string) {
        Hashtable hashtable = SnmpSessionFactory.getConfigInfo((String)string);
        Serializable serializable = (Serializable)hashtable.get("writeComm");
        if (serializable != null) {
            return serializable.toString();
        }
        return NMPlatformDBClient.getWriteCommunityName(string);
    }

    private MenuItem getDeviceMenuItem(String string) {
        MenuItem menuItem = new MenuItem(resources.getString("open_java_device_view"));
        menuItem.addActionListener(new 1(string, this));
        return menuItem;
    }

    private String getOidFromDB(String string) {
        String string2 = "getOidFromDB";
        try {
            String string3 = NMPlatformDBClient.getSysOid(string);
            if (!string3.startsWith("1.3.6")) {
                return "0.0";
            }
            return string3;
        }
        catch (Exception exception) {
            RAS.logException(19, 1008, this, string2, exception);
            return "0.0";
        }
    }

    private static String getImageFromOid(String string) {
        int n = 0;
        while (n < oidToImage.length) {
            if (string.equals(oidToImage[n][0])) {
                return oidToImage[n][1];
            }
            ++n;
        }
        return "icon_gen.gif";
    }

    private static final class 1
    implements ActionListener {
        private final /* synthetic */ String val$ip;
        private final /* synthetic */ AtmView this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            NwaysPlatformEuiStart.StartJMAFromIpAddress((BrowserApplet)this.this$0.browser, (String)this.val$ip, (String)this.this$0.getReadCommunity(this.this$0.db, this.val$ip), (String)this.this$0.getWriteCommunity(this.this$0.db, this.val$ip));
        }

        /* synthetic */ 1(String string, AtmView atmView) {
            this.val$ip = string;
            this.this$0 = atmView;
        }
    }
}

